<?php
$channelAccessToken = 'xxx';
date_default_timezone_set('Asia/Jakarta');
$dbFilePath = 'line-db.json';        // user info database file path

if (!file_exists($dbFilePath)) {
   file_put_contents($dbFilePath, json_encode(['user' => []]));
}
$db = json_decode(file_get_contents($dbFilePath), true);
$bodyMsg = file_get_contents('php://input');
//file_put_contents('log.txt', date('Y-m-d H:i:s') . ' Receive: ' . $bodyMsg);
$obj = json_decode($bodyMsg, true);
//file_put_contents('log.txt', print_r($db, true));

foreach ($obj['events'] as &$event) {
   $userId = $event['source']['userId'];
   $pesan = $event['message']['text'];
   file_put_contents('log.txt', date('Y-m-d H:i:s') . ' Receive: ' . $pesan);
   if (!isset($db['user'][$userId])) {
	   $db['user'][$userId] = [
		   'userId' => $userId,
		   'timestamp' => $event['timestamp']
	   ];
	   file_put_contents($dbFilePath, json_encode($db));
	   $message = 'Selamat datang di kanal Line';
	   // Make payload
	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [
			   [
				   'type' => 'text',
				   'text' => $message
			   ]
		   ]
	   ];
   } else {
	   if($event['message']['text']=='map') {
	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [ [ 
					'type' => 'location',					
					'title' => 'Unika Soegijapranata. Klik Detail',					
					'address' => 'Semarang',					
					'latitude' => '-7.0265536',					
					'longitude' => '110.4139781' 
			] ]
		];
	   }
		else if($event['message']['text']=='jam') {
	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [ [ 
					'type' => 'text',					
					'text' => 'Jam Server: '. date('Y-m-d H:i:s')
			] ]
		];
		}
		else if($event['message']['text']=='fungsi') {
	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [ [ 
					'type' => 'text',					
					'text' => 'Fungsi PHP base64_encode unika.ac.id :'. base64_encode("unika.ac.id")
			] ]
		];
		}
		else if($event['message']['text']=='logo') {
 	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [ [ 
						'type' => 'image',									
						'originalContentUrl' => 'https://ridwanbot.000webhostapp.com/logo.jpg',
						'previewImageUrl' => 'https://ridwanbot.000webhostapp.com/logo.jpg'		
			] ]
		];	   
		}
		else if($event['message']['type']=='sticker') {
		   $payload = [
			   'replyToken' => $event['replyToken'],
			   'messages' => [
				   [
                      'type' => 'sticker',
                      'packageId' => '1',
                      'stickerId' => '1'
				   ]
			   ]
		   ];			
		}       
       else {
	   //$message = 'Anda baru saja mengetikkan ' . $pesan;	 
	    $bot_url="http://xxx/conversation_start.php?bot_id=1&convo_id=&say=";
	    $no_answer="No Answer";
        $json = file_get_contents($bot_url.rawurlencode($pesan));
        if($json) {
          $obj = json_decode($json);
          if($obj->botsay!=$no_answer)
          {
            $message = $obj->botsay;
          } else {
            $message = "Maaf, saya belum bisa jawab";
          }
        }
	   // Make payload
	   $payload = [
		   'replyToken' => $event['replyToken'],
		   'messages' => [
			   [
				   'type' => 'text',
				   'text' => $message
			   ]
		   ]
	   ];
       }
   }
   
   // Send reply API
   $ch = curl_init();
   curl_setopt($ch, CURLOPT_URL, 'https://api.line.me/v2/bot/message/reply');
   curl_setopt($ch, CURLOPT_POST, true);
   curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
   curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
   curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
   curl_setopt($ch, CURLOPT_HTTPHEADER, [
       'Content-Type: application/json',
       'Authorization: Bearer ' . $channelAccessToken
   ]);
   $result = curl_exec($ch);
   curl_close($ch);
   
}
       

?>