<?php
$answer = 'Halo. Ada yang bisa saya bantu?';
$convo_id = '';

if (isset($_GET['say'])) {
	$say  = rawurlencode($_GET['say']);
	$bot_id = 1;
	$convo_id = $_GET['convo_id'] ?? '';

	$url = "https://dannus.siega23.com/Program-O/chatbot/conversation_start.php?bot_id={$bot_id}&say={$say}&convo_id={$convo_id}";
	$json = @file_get_contents($url);

	if ($json) {
		$data   = json_decode($json);
		$answer = $data->botsay ?? 'Maaf, saya tidak mengerti.';
		$convo_id = $data->convo_id ?? '';
	} else {
		$answer = 'Bot sedang offline.';
	}

	header('Content-Type: application/json');
	echo json_encode(['reply' => $answer, 'convo_id' => $convo_id]);
	exit;
}

$say_init = rawurlencode('HELLO');
$bot_id = 1;
$url_init = "https://dannus.siega23.com/Program-O/chatbot/conversation_start.php?bot_id={$bot_id}&say={$say_init}";
$json_init = @file_get_contents($url_init);

if ($json_init) {
	$data_init = json_decode($json_init);
	$answer = $data_init->botsay ?? 'Halo. Ada yang bisa saya bantu?';
	$convo_id = $data_init->convo_id ?? '';
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Virtual Assistant</title>

<style>
body{
	margin:0;
	font-family:Arial, sans-serif;
	background:#f4f6fa;
	display:flex;
	justify-content:center;
	align-items:center;
	height:100vh;
}

.main-wrapper{
	width:100%;
	height:100vh;
	background:#fff;
	display:flex;
	justify-content:center;
	align-items:center;
}

/* ===== PANEL AVATAR FULL MOBILE ===== */
.sidebar{
	width:100%;
	height:100%;
	display:flex;
	flex-direction:column;
	align-items:center;
	justify-content:center;
}

.avatar-4-container{
	position:relative;
	width:230px;
	height:230px;
	margin-bottom:12px;
}

.avatar-4-container img{
	position:absolute;
	width:95px;
	height:95px;
	border-radius:50%;
	object-fit:cover;
	border:3px solid #ddd;
	background:#fff;
}

/* 4 arah bertemu di tengah */
#avatar1{ top:0; left:67px; }
#avatar2{ bottom:0; left:67px; }
#avatar3{ left:0; top:67px; }
#avatar4{ right:0; top:67px; }

.bot-name{
	font-size:18px;
	font-weight:bold;
}

.bot-role{
	font-size:12px;
	color:#777;
	margin-top:4px;
}

/* ===== KONTROL (MINIMAL) ===== */
.control-box{
	margin-top:20px;
	display:flex;
	gap:10px;
}

.control-box button{
	padding:12px 18px;
	border:none;
	border-radius:10px;
	font-size:14px;
	cursor:pointer;
}

#bSend{
	background:#28a745;
	color:#fff;
}

/* Chat disembunyikan (voice only dari ESP32) */
.chat-area,
.chat-messages,
.chat-input{
	display:none;
}
</style>
</head>

<body>

<div class="main-wrapper">

	<div class="sidebar">

		<div class="avatar-4-container">
			<img src="dc.png" id="avatar1">
			<img src="dc.png" id="avatar2">
			<img src="dc.png" id="avatar3">
			<img src="dc.png" id="avatar4">
		</div>

		<div class="bot-name">Pedro Salto</div>
		<div class="bot-role">Virtual Assistant</div>

		<!-- Tombol manual (opsional jika ESP32 belum aktif) -->
		<div class="control-box">
			<button id="bSend">KIRIMAN</button>
		</div>

	</div>

</div>

<script>
const avatars = [
	document.getElementById('avatar1'),
	document.getElementById('avatar2'),
	document.getElementById('avatar3'),
	document.getElementById('avatar4')
];

const staticAvatars = ['dc.png','dc.png','dc.png','dc.png'];
const animatedAvatar = 'dc.gif';

let currentConvoId = '<?= $convo_id ?>';

/* === MODE SPEAK (OUTPUT SUARA KE USER) === */
function speak(text){
	speechSynthesis.cancel();
	const u = new SpeechSynthesisUtterance(text);
	u.lang='id-ID';

	avatars.forEach(a=>a.src=animatedAvatar);

	u.onend=()=>{
		avatars.forEach((a,i)=>a.src=staticAvatars[i]);
	};

	speechSynthesis.speak(u);
}

/* === MODE KIRIM PESAN (NANTINYA DARI ESP32) === */
async function askBot(text){
	const res = await fetch('?say='+encodeURIComponent(text)+'&convo_id='+currentConvoId);
	const data = await res.json();
	currentConvoId = data.convo_id;
	speak(data.reply);
}

/* Tombol manual hanya untuk testing */
document.getElementById('bSend').onclick = ()=>{
	askBot('Halo');
};

/* Autoplay jawaban awal */
setTimeout(()=>{
	speak('<?= addslashes($answer) ?>');
},300);
</script>

</body>
</html>
